//==============================================================================
//Copyright (c)2011 LS MotionControl. All rights reserved.
//==============================================================================
//MODULE		: A1_MotionAPI.h
//Project		: MXP/A1
//ABSTRACT		: 
//Environment	: Win32
//NOTE			: 
//==============================================================================
//Revision History
//Version	Date		Author			Comments
//-------	----------	--------------	----------------------------------------
//0.1		2011.12.16	Dr. J.Park		Baseline
//------------------------------------------------------------------------------

//#pragma warning(disable : 4996)
#pragma once

// Selection of DLL or Lib according to pre-processor by Lee Jong Hyuck 13.11.05
#if defined(_USEDLL) || defined(_USRDLL) || defined(_AFXEXT)
#ifdef RMCSOFTMOTION_DLL
#define RMC_ETHERCAT_API __declspec( dllexport )
#else
#define RMC_ETHERCAT_API __declspec( dllimport )
#endif
#else
#ifdef RMCSOFTMOTION_DLL
#define RMC_ETHERCAT_API 
#else
#define RMC_ETHERCAT_API 
#endif
#endif

#define IN
#define OUT

///////////////////////////////////////////////////////////////////////////////
// Error code
///////////////////////////////////////////////////////////////////////////////

#define RMC_ERROR_NOERR					0x0000
#define RMC_ERROR_KERNEL_ALREADY_RUN	0x0001
#define RMC_ERROR_ENI_XML_INVALID		0x0002
#define RMC_ERROR_NO_SLAVE				0x0003
#define RMC_ERROR_KERNEL_NOT_INIT		0x0004
#define RMC_ERROR_SLAVE_TYPE_INVALID	0x0005
#define RMC_ERROR_NO_CIA402_DEVICE		0x0006
#define RMC_ERROR_CHANNEL_INVALID		0x0007
#define RMC_ERROR_ALREADY_INITIALIZED	0x0008
#define RMC_ERROR_INVALID_PARAM			0x0009
#define RMC_ERROR_PARAM_RANGE_OVER		0x000A
#define RMC_ERROR_DEVICE_NOT_READY		0x000B
#define RMC_ERROR_UNKNOWN				0x1000

typedef enum
{
	NET_STATE_INIT		= 0x01,
	NET_STATE_PREOP		= 0x02,
	NET_STATE_SAFEOP	= 0x04,
	NET_STATE_OP		= 0x08
} RMC_NETWORK_SATUS;

#ifndef MAILBOXCMD_CANOPEN_SDO

#define MAILBOXCMD_CANOPEN_SDO				0xF302		
#define MAILBOXCMD_CANOPEN_SDO_INFO_LIST	0xF3FC	// listType = index
#define MAILBOXCMD_CANOPEN_SDO_INFO_OBJ		0xF3FD
#define MAILBOXCMD_CANOPEN_SDO_INFO_ENTRY	0xF3FE

#define	ECAT_COE_INFO_LIST_TYPE_LENGTH		0
#define	ECAT_COE_INFO_LIST_TYPE_ALL			1
#define	ECAT_COE_INFO_LIST_TYPE_RXPDOMAP	2
#define	ECAT_COE_INFO_LIST_TYPE_TXPDOMAP	3
#define	ECAT_COE_INFO_LIST_TYPE_BACKUP		4

typedef enum 
{
	EC_CMD_TYPE_NOP		= 0,
	EC_CMD_TYPE_APRD	= 1,
	EC_CMD_TYPE_APWR	= 2,
	EC_CMD_TYPE_APRW	= 3,
	EC_CMD_TYPE_FPRD	= 4,
	EC_CMD_TYPE_FPWR	= 5,
	EC_CMD_TYPE_FPRW	= 6,
	EC_CMD_TYPE_BRD		= 7,
	EC_CMD_TYPE_BWR		= 8,
	EC_CMD_TYPE_BRW		= 9,
	EC_CMD_TYPE_LRD		= 10,
	EC_CMD_TYPE_LWR		= 11,
	EC_CMD_TYPE_LRW		= 12,
	EC_CMD_TYPE_ARMW	= 13,
	EC_CMD_TYPE_EXT		= 255,
} EC_CMD_TYPE;

#define	EC_HEAD_IDX_ACYCLIC_MASK	0x80
#define	EC_HEAD_IDX_SLAVECMD		0x80
#define	EC_HEAD_IDX_EXTERN_VALUE	0xFF
#define	EC_HEAD_IDX_CYCLIC_START	0x01


#define	ESC_REG_ESC_TYPE				0x0000	// --> ET1000 local address
#define	ESC_REG_ESC_REVISION			0x0001
#define	ESC_REG_ESC_BUILD				0x0002

#define	ESC_REG_FEATURES				0x0008
#define	ESC_FEATURE_DC_AVAILABLE	0x0004
#define	ESC_FEATURE_DC64_AVAILABLE	0x0008

//////////////////////////////////////////////

#define ESC_REG_CONFIG_STATION_ADDR		0x0010
#define ESC_REG_CONFIG_STATION_ALIAS	0x0012

#define ESC_REG_WR_REG_ENABLE			0x0020
#define ESC_REG_WR_REG_PROTECT			0x0021
#define ESC_REG_WR_ENABLE				0x0030
#define ESC_REG_WR_PROTECT				0x0031

#define ESC_REG_RST_ECAT				0x0040
#define ESC_REG_RST_PDI					0x0041
#define ESC_REG_ESC_DL_CNTL0			0x0100		//:0x0103 4
#define ESC_REG_PHY_RW_OFFSET			0x0108		//:0x0109 2
#define ESC_REG_ESC_DL_STATUS			0x0110		//:0x0111 2
//Application Layer
#define ESC_REG_AL_CNTL					0x0120		//:0x0121 2
#define ESC_REG_AL_STATUS				0x0130		//:0x0131 2
#define ESC_REG_AL_STATUS_CODE			0x0134		//:0x0135 2

//ESI EEPROM Interface
#define ESC_REG_EEPROM_CONFIG			0x0500
#define ESC_REG_EEPROM_PDI_ACCESS_STAT	0x0501
#define ESC_REG_EEPROM_CNTR_STAT		0x0502		//:0x0503 2 EEPROM Control/Status
#define ESC_REG_EEPROM_ADDR				0x0504		//:0x0507 4 EEPROM Address
#define ESC_REG_EEPROM_DATA				0x0508		//:0x050F 4/8 EEPROM Data

//////////////////////////////////////////////

#define	ESC_REG_ESC_STATUS				0x0111
#define	EC_REG_PDI_CTRL					0x0140

#define	ESC_REG_SYNCMAN_MBX_OUT			0x0800	//
// +0x0:0x1 : Physical Start Address
// +0x2:0x3 : Length
// +0x4		: Control Register
// +0x5		: Status Register
// +0x6		: Activate
// +0x7		: PDI Control
#define	ESC_REG_SYNCMAN_MBX_IN			0x0808

#define	ESC_REG_SYNCMAN0				0x0800
#define	ESC_REG_SYNCMAN1				0x0808
#define	ESC_REG_SYNCMAN2				0x0810
#define	ESC_REG_SYNCMAN3				0x0818
#define	ESC_REG_SYNCMAN4				0x0820
#define	ESC_REG_SYNCMAN5				0x0828
#define	ESC_REG_SYNCMAN6				0x0830
#define	ESC_REG_SYNCMAN7				0x0838
#define	ESC_REG_SYNCMAN8				0x0840
#define	ESC_REG_SYNCMAN9				0x0848
#define	ESC_REG_SYNCMAN10				0x0850
#define	ESC_REG_SYNCMAN11				0x0858
#define	ESC_REG_SYNCMAN12				0x0860
#define	ESC_REG_SYNCMAN13				0x0868
#define	ESC_REG_SYNCMAN14				0x0870
#define	ESC_REG_SYNCMAN15				0x0878

#define	ESC_STATUS_LOOP_A_MASK			0x0300
#define	ESC_STATUS_LOOP_A_CLOSE			0x0100
#define	ESC_STATUS_LOOP_A_LINK			0x0200
#define	ESC_STATUS_LOOP_B_MASK			0x0C00
#define	ESC_STATUS_LOOP_B_CLOSE			0x0400
#define	ESC_STATUS_LOOP_B_LINK			0x0800
#define	ESC_STATUS_LOOP_C_MASK			0x3000
#define	ESC_STATUS_LOOP_C_CLOSE			0x1000
#define	ESC_STATUS_LOOP_C_LINK			0x2000
#define	ESC_STATUS_LOOP_D_MASK			0xC000
#define	ESC_STATUS_LOOP_D_CLOSE			0x4000
#define	ESC_STATUS_LOOP_D_LINK			0x8000

#define	ESC_REG_DC_SOF_LATCH_A			0x0900
#define	ESC_REG_DC_SOF_LATCH_B			0x0904
#define	ESC_REG_DC_SOF_LATCH_C			0x0908
#define	ESC_REG_DC_SOF_LATCH_D			0x090c

#define	ESC_REG_DC_SYSTIME				0x0910
#define	ESC_REG_DC_SOF_LATCH_A_64		0x0918
#define	ESC_REG_DC_SYSTIME_OFFS			0x0920
#define	ESC_REG_DC_SYSTIME_DELAY		0x0928
#define	ESC_REG_DC_CONTROL_ERROR		0x092c
#define	ESC_REG_DC_SPEED_START			0x0930
#define	ESC_REG_DC_SPEED_DIFF			0x0932
#define	ESC_REG_DC_FILTER_EXP			0x0934
#define	ESC_REG_DC_SOF_LATCH_FRAME		0x0936

#define	ESC_REG_DC_CYC_START_TIME		0x0990

#define	ESC_REG_DIGITAL_OUTPUTS			0x0f00

typedef struct TETHERCAT_SDO_INFO_LIST
{
	USHORT	ListType;				// == SDO_INFO_LIST_TYPE_XXX
	struct
	{
		USHORT	Index[1];		
	} Res;
} ETHERCAT_SDO_INFO_LIST, *PETHERCAT_SDO_INFO_LIST;

typedef struct TETHERCAT_SDO_INFO_OBJ
{
	USHORT	Index;
	struct
	{
		USHORT	DataType;				// refer to data type index
		BYTE	MaxSubIndex;			// max subIndex
		BYTE	ObjCode			: 4;	// defined in DS 301 (Table 37)
		BYTE	ObjCategory		: 1;	// 0=optional, 1=mandatory
		BYTE	Reserved		: 3;	// == 0
		CHAR	Name[1];				// rest of mailbox data
	} Res;
} ETHERCAT_SDO_INFO_OBJ, *PETHERCAT_SDO_INFO_OBJ;

typedef struct TETHERCAT_SDO_INFO_ENTRY
{
	USHORT	Index;
	BYTE		SubIdx;	
	BYTE		ValueInfo;				// bit0 = ObjAccess, bit1 = ObjCategory, bit2 = PdoMapping, bit3 = UnitType
	// bit4 = DefaultValue, bit5 = MinValue, bit6 = MaxValue
	struct
	{
		USHORT	DataType;				// refer to data type index
		USHORT	BitLen;
		USHORT	ObjAccess		: 6;	// bit0 = read; bit1 = write; bit2 = const. bit3 = PRE-OP? bit4 = SAFE-OP? bit5 = OP?
		USHORT	RxPdoMapping	: 1;	// 
		USHORT	TxPdoMapping	: 1;	// 
		USHORT	Reserved		: 8;	// for future use
		//		USHORT	UnitType;				// optional if bit3 of valueInfo
		//		BYTE		DefaultValue[];		// optional if bit4 of valueInfo
		//		BYTE		MinValue[];				// optional if bit5 of valueInfo
		//		BYTE		MaxValue[];				// optional if bit6 of valueInfo
		//		CHAR		Desc[];					// rest of mailbox data
	} Res;
} ETHERCAT_SDO_INFO_ENTRY, *PETHERCAT_SDO_INFO_ENTRY;

typedef struct TETHERCAT_SDO_INFO_ERROR
{
	ULONG		ErrorCode;
	CHAR		ErrorText[1];				// rest of mailbox data
} ETHERCAT_SDO_INFO_ERROR, *PETHERCAT_SDO_INFO_ERROR;

#endif

extern "C" RMC_ETHERCAT_API int  RMC_InitKernel(IN CString &strENIXML,OUT int &iNumOfScannedNode);
extern "C" RMC_ETHERCAT_API int  RMC_GetKernelStatus();						// return: initialization status
extern "C" RMC_ETHERCAT_API int  RMC_GetNodeType(int iSlaveNo, UINT16 &uiNodeType); // 0:none,1:402,2:401
extern "C" RMC_ETHERCAT_API int  RMC_SetOnlineMode(IN int iMode);			// 0:off-line 1:on-line
extern "C" RMC_ETHERCAT_API int  RMC_GetOnlineMode();						// return: network status
extern "C" RMC_ETHERCAT_API int  RMC_Stop();
extern "C" RMC_ETHERCAT_API UINT RMC_SDOSyncDownloadReq( IN ULONG nInvokeId, IN USHORT nSlave, IN ULONG nCmdId, IN USHORT nIndex, IN BYTE nSubIndex, IN ULONG cbWrLength, IN BYTE *pWrData );
extern "C" RMC_ETHERCAT_API UINT RMC_SDOSyncUploadReq  ( IN ULONG nInvokeId, IN USHORT nSlave, IN ULONG nCmdId, IN USHORT nIndex, IN BYTE nSubIndex, IN ULONG cbRdLength, OUT BYTE *pRdData, OUT ULONG &cbRead );

extern "C" RMC_ETHERCAT_API UINT RMC_EcatSyncDownloadReq( IN ULONG nInvokeId, IN BYTE cmd, IN BYTE idx, IN USHORT adp, IN USHORT ado, IN ULONG cbWrLength, IN BYTE *pWrData);
extern "C" RMC_ETHERCAT_API UINT RMC_EcatSyncUploadReq	( IN ULONG nInvokeId, IN BYTE cmd, IN BYTE idx, IN USHORT adp, IN USHORT ado, IN ULONG cbRdLength, OUT BYTE *pRdData, OUT ULONG &cbRead);
	
